/*-------------------------------------*\
|  Nokia LCD (Phillips PCF8833) Demo	|
| This demo shows how the LCD from many	|
| Nokia cell phones can be interfaced 	|
| with an AVR microcontroller for use 	|
| in projects.  This demo implements	|
| color, rectangle drawing, text, menus	|
| and picture-over-serial.				|
|										|
| Adam Honse (CalcProgrammer1)			|
| 5/10/2011								|
\*-------------------------------------*/

#include <avr/io.h>
#include <util/delay.h>

#include "color_lcd.h"
#include "color_lcd_text.h"
#include "color_lcd_menu.h"
#include "serial.h"

int HSVtoRGB(int h, char s, char v);

const char demo_menu[5][22] = {	"Nokia LCD Demo",
								"1. Test Colors",
								"2. Test Text",
								"3. Test Numbers",
								"4. Picture by Serial" };
int main()
{
	color_lcd_initialize();
	serial_init(10);
	sei();

	color_lcd_draw_rectangle(0x0FFF, 0, 0, 131, 131);
	while(1)
	{
		char sel = color_lcd_print_menu(demo_menu, 4, 1, 0x0FFF, 0x000F, 0x0000, 0x0FFF, 0x0FFF, 0x0000);
		switch(sel)
		{
			case 1:
			{
				//Option 1 - Test Colors
				color_lcd_draw_rectangle(0x0000,0,0,131,131);
				for(char x = 0; x < 130; x++)
				{
					for(char y = 0; y < 130; y++)
					{
						color_lcd_set_pixel(HSVtoRGB(2.7*y,255,1.9*x),x,y);
					}
				}
				while(!bit_is_clear(PINC, PC2));
			}
			break;

			case 2:
			{
				//Option 2 - Test Text
				color_lcd_draw_rectangle(0x0000,0,0,131,131);
				color_lcd_print_char('A', 0x0FF0, 3, 3);
				color_lcd_print_string("Hello World", 11, 0x00F0, 10, 25);
				color_lcd_print_string("LCD Demo!", 9, 0x000F, 20, 36);
				color_lcd_print_string("Text Demo", 9, 0x0F00, 40, 60);
				while(!bit_is_clear(PINC, PC2));
			}
			break;

			case 3:
			{
				//Option 3 - Test Numbers
				//Use sprintf to convert numerical values (including ints, floats, chars that are used as ints, etc)
				// into strings, then print the strings using either the print_string or print_menu_line functions.
				// The print_menu_line function can be used to print nicely formatted strings, set up a basic terminal,
				// and otherwise use the graphical LCD like a character LCD.
				char value = 0;
				char val_text[21] = "0";
				color_lcd_draw_rectangle(0x0000,0,0,131,131);
				color_lcd_print_menu_line("Number Demo",12,0x0F0F, 0x0FF0, 0);
				color_lcd_print_menu_line(val_text,21,0x0000,0x000F, 2);
				while(!bit_is_clear(PINC, PC2))
				{
					if(bit_is_clear(PINC, PC0))
					{
						value++;
						sprintf(val_text,"%d",value);
						color_lcd_print_menu_line(val_text,21,0x0000,0x000F, 2);
					}
					if(bit_is_clear(PINC, PC1))
					{
						value--;
						sprintf(val_text,"%d",value);
						color_lcd_print_menu_line(val_text,21,0x0000,0x000F, 2);
					}
					_delay_ms(1000);
				}
			}

			case 4:
			{
				for(char x = 1; x < 131; x++)
				{
					for(char y = 1; y < 131; y++)
					{
						while(serial_available() < 2)
						{
						}
						int color = (serial_read() << 8) | serial_read();
						color_lcd_set_pixel(color, x, y);
					}
				}
				while(!bit_is_clear(PINC, PC2));
			}
		}
	}
}

int HSVtoRGB(int h, char s, char v)
{
	char r;
	char g;
	char b;

	char f = ((h%60)*255)/60;

	h /= 60;

	char p = (255 - s);
	char q = (255 - (s*f)/256);
	char t = (255 - (s*(255-f))/256);

	switch(h)
	{
		case 0:
			r = v;
			g = (t*v)/256;
			b = (p*v)/256;
		break;

		case 1:
			r = (q*v)/256;
			g = v;
			b = (p*v)/256;
		break;

		case 2:
			r = (p*v)/256;
			g = v;
			b = (t*v)/256;
		break;

		case 3:
			r = (p*v)/256;
			g = (q*v)/256;
			b = v;
		break;

		case 4:
			r = (t*v)/256;
			g = (p*v)/256;
			b = v;
		break;

		default:
			r = v;
			g = (p*v)/256;
			b = (q*v)/256;
		break;
	}

	return (((r-1)/16)<<8) + (((g-1)/16)<<4) + (((b-1)/16));
}
